﻿//////////////////////////////////////////////
// ScriptEngine.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Forward decl -----------------------------

namespace nkAstraeus
{
	class LogManager ;
	class System ;
}

namespace nkScripts
{
	class Environment ;
}

/// Includes ---------------------------------

// nkAstraeus
#include "../Dll/DllDefines.h"

// nkMemory
#include <NilkinsMemory/Pointers/UniquePtr.h>

/// Class ------------------------------------

namespace nkAstraeus
{
	class DLL_ASTRAEUS_EXPORT ScriptsEngine final
	{
		public :

			// Constructor, destructor
			ScriptsEngine (System* system = nullptr) noexcept ;
			~ScriptsEngine () ;

			// Getters
			nkScripts::Environment* getEnvironment () const ;

			// Lifetime
			bool initialize () ;
			void shutdown () ;

		public :

			// Statics
			static void setupScriptsEnvironment (nkScripts::Environment* environment, LogManager* targetLogManager) ;

		private :

			// Attributes
			nkMemory::UniquePtr<nkScripts::Environment> _environment ;
			System* _system ;
	} ;
}